<?php
/**
 * FUNCIONES BÁSICAS - DOMAIN MANAGER
 * 
 * Funciones mínimas para evitar conflictos
 * Fecha: 2025-11-12
 * Versión: 1.0 Stable
 */

/**
 * Obtener conexión PDO a la base de datos
 * Retorna: PDO|null
 */
function getDBConnection() {
    static $pdo = null;
    
    if ($pdo === null) {
        try {
            $dsn = 'mysql:host=' . DB_HOST . ';dbname=' . DB_NAME . ';charset=' . DB_CHARSET;
            $options = [
                PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
                PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
                PDO::ATTR_EMULATE_PREPARES => false,
                PDO::MYSQL_ATTR_INIT_COMMAND => "SET NAMES utf8"
            ];
            
            $pdo = new PDO($dsn, DB_USER, DB_PASS, $options);
        } catch (PDOException $e) {
            error_log('Error de conexión a la base de datos: ' . $e->getMessage());
            throw new Exception('No se pudo conectar a la base de datos');
        }
    }
    
    return $pdo;
}
?>