-- DOMAIN MANAGER - BASE DE DATOS
-- Versión: 1.0 Stable
-- Fecha: 2025-11-12
-- Base de datos: freehosting_domain

CREATE DATABASE IF NOT EXISTS `freehosting_domain` CHARACTER SET utf8 COLLATE utf8_general_ci;
USE `freehosting_domain`;

-- Tabla de usuarios
CREATE TABLE IF NOT EXISTS `users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `username` varchar(50) NOT NULL,
  `email` varchar(100) NOT NULL,
  `password` varchar(255) NOT NULL,
  `role` enum('admin','user') DEFAULT 'admin',
  `is_active` tinyint(1) DEFAULT 1,
  `last_login` datetime DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `username` (`username`),
  UNIQUE KEY `email` (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

-- Tabla de dominios
CREATE TABLE IF NOT EXISTS `domains` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `extension` varchar(10) NOT NULL,
  `registrar` varchar(100) DEFAULT NULL,
  `registration_date` date DEFAULT NULL,
  `expiry_date` date DEFAULT NULL,
  `status` tinyint(1) DEFAULT 1,
  `notes` text DEFAULT NULL,
  `auto_renew` tinyint(1) DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idx_expiry_date` (`expiry_date`),
  KEY `idx_registrar` (`registrar`),
  KEY `idx_domain_extension` (`name`, `extension`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

-- Tabla de log de actividades
CREATE TABLE IF NOT EXISTS `activity_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `action` varchar(100) NOT NULL,
  `details` text DEFAULT NULL,
  `ip_address` varchar(45) DEFAULT NULL,
  `user_agent` text DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idx_user_id` (`user_id`),
  KEY `idx_action` (`action`),
  KEY `idx_created_at` (`created_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

-- Insertar usuario administrador por defecto
-- Contraseña: password (hash)
INSERT INTO `users` (`username`, `email`, `password`, `role`, `is_active`) VALUES
('admin', 'admin@freehosting.com.ve', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'admin', 1);

-- Insertar dominios de prueba completos
INSERT INTO `domains` (`name`, `extension`, `registrar`, `registration_date`, `expiry_date`, `status`, `auto_renew`, `notes`) VALUES
('sas', 'com', 'GoDaddy', '2023-01-15', '2025-12-31', 1, 1, 'Dominio principal de la empresa'),
('miempresa', 'com', 'Namecheap', '2022-06-10', '2025-06-10', 1, 0, 'Dominio corporativo'),
('tiendaonline', 've', 'NIC.VE', '2023-03-20', '2025-03-20', 1, 1, 'E-commerce nacional'),
('blogpersonal', 'org', 'Cloudflare', '2023-08-05', '2025-08-05', 1, 1, 'Blog personal y artículos'),
('proyectoapp', 'com', 'Google Domains', '2024-01-10', '2025-01-10', 1, 0, 'Aplicación móvil en desarrollo'),
('consultoria', 'net', 'GoDaddy', '2023-11-15', '2024-11-15', 0, 0, 'Dominio inactivo - renovar'),
('servicios', 'info', 'Namecheap', '2023-09-30', '2025-09-30', 1, 1, 'Sitio de servicios profesionales'),
('innovacion', 'tech', 'Cloudflare', '2024-02-14', '2025-02-14', 1, 0, 'Startup tecnológica'),
('empresaldigital', 'biz', 'GoDaddy', '2023-05-25', '2025-05-25', 1, 1, 'Empresa de marketing digital'),
('portafolio', 'io', 'Namecheap', '2024-03-12', '2025-03-12', 1, 0, 'Portafolio profesional');

-- Insertar actividad del sistema y dominios
INSERT INTO `activity_log` (`user_id`, `action`, `details`, `ip_address`, `created_at`) VALUES
(1, 'Sistema iniciado', 'Domain Manager iniciado correctamente', '127.0.0.1', NOW()),
(1, 'Dominio agregado', 'Dominio sas.com agregado', '127.0.0.1', DATE_SUB(NOW(), INTERVAL 100 DAY)),
(1, 'Dominio agregado', 'Dominio miempresa.com agregado', '127.0.0.1', DATE_SUB(NOW(), INTERVAL 90 DAY)),
(1, 'Dominio agregado', 'Dominio tiendaonline.ve agregado', '127.0.0.1', DATE_SUB(NOW(), INTERVAL 80 DAY)),
(1, 'Dominio agregado', 'Dominio blogpersonal.org agregado', '127.0.0.1', DATE_SUB(NOW(), INTERVAL 70 DAY)),
(1, 'Dominio agregado', 'Dominio proyectoapp.com agregado', '127.0.0.1', DATE_SUB(NOW(), INTERVAL 60 DAY)),
(1, 'Dominio agregado', 'Dominio consultoria.net agregado', '127.0.0.1', DATE_SUB(NOW(), INTERVAL 50 DAY)),
(1, 'Dominio agregado', 'Dominio servicios.info agregado', '127.0.0.1', DATE_SUB(NOW(), INTERVAL 40 DAY)),
(1, 'Dominio agregado', 'Dominio innovacion.tech agregado', '127.0.0.1', DATE_SUB(NOW(), INTERVAL 30 DAY)),
(1, 'Dominio agregado', 'Dominio empresaldigital.biz agregado', '127.0.0.1', DATE_SUB(NOW(), INTERVAL 20 DAY)),
(1, 'Dominio agregado', 'Dominio portafolio.io agregado', '127.0.0.1', DATE_SUB(NOW(), INTERVAL 10 DAY)),
(1, 'Dominio desactivado', 'Dominio consultoria.net desactivado - renovación pendiente', '127.0.0.1', DATE_SUB(NOW(), INTERVAL 5 DAY));

-- Crear índices adicionales
ALTER TABLE `domains` ADD INDEX `idx_status_expiry` (`status`, `expiry_date`);

-- Notas:
-- - Usuario por defecto: admin
-- - Contraseña por defecto: password  
-- - Dominios incluidos para pruebas:
--   * sas.com (activo, vence 31/12/2025) - Principal
--   * miempresa.com (activo, vence 10/06/2025) - Corporativo
--   * tiendaonline.ve (activo, vence 20/03/2025) - Nacional
--   * blogpersonal.org (activo, vence 05/08/2025) - Personal
--   * proyectoapp.com (activo, vence 10/01/2025) - En desarrollo
--   * consultoria.net (INACTIVO, vence 15/11/2024) - Renovación pendiente
--   * servicios.info (activo, vence 30/09/2025) - Profesional
--   * innovacion.tech (activo, vence 14/02/2025) - Startup
--   * empresaldigital.biz (activo, vence 25/05/2025) - Marketing
--   * portafolio.io (activo, vence 12/03/2025) - Profesional
-- - Total: 10 dominios (9 activos, 1 inactivo)
-- - Diferentes registradores: GoDaddy, Namecheap, Cloudflare, Google Domains, NIC.VE
-- - Para acceso directo al dashboard: index.php (redirige a dashboard.php)